<?php
/**
 * Site Builder Configuration
 * 
 * IMPORTANT: Update these values before deploying
 */

// OpenAI API Key (for ChatGPT content generation)
define('OPENAI_API_KEY', 'your-openai-api-key-here');

// Anthropic API Key (for Claude design - optional, uses templates if not set)
define('ANTHROPIC_API_KEY', '');

// Unsplash API Key (for free images)
define('UNSPLASH_ACCESS_KEY', 'your-unsplash-access-key-here');

// Paths
define('BASE_PATH', __DIR__);
define('TEMPLATES_PATH', BASE_PATH . '/templates');
define('GENERATED_PATH', BASE_PATH . '/generated');
define('ASSETS_PATH', BASE_PATH . '/assets');

// Site settings
define('SITE_URL', 'https://life-tools.app/site-builder');
define('MAX_GENERATION_TIME', 120); // seconds

// Content settings
define('MIN_WORDS_PER_SECTION', 80);
define('MIN_TOTAL_WORDS', 1500);
define('NUM_FAQ_ITEMS', 6);
define('NUM_SERVICES', 4);

// Error reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Timezone
date_default_timezone_set('UTC');

// Clean up old generated files (older than 1 hour)
function cleanupOldFiles() {
    $files = glob(GENERATED_PATH . '/*.zip');
    $now = time();
    foreach ($files as $file) {
        if ($now - filemtime($file) > 3600) {
            @unlink($file);
        }
    }
}
