<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Builder | Life Tools</title>
    <meta name="description" content="Generate professional, Google Ads compliant websites instantly. Just enter your domain, business type, and industry.">
    <meta name="robots" content="noindex, nofollow">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/builder.css">
</head>
<body>
    <div class="bg-glow"></div>

    <div class="container">
        <header class="header">
            <div class="logo">
                <div class="logo-icon">⚡</div>
                <span class="logo-text">Site Builder</span>
            </div>
            <p class="tagline">AI-powered websites in 60 seconds</p>
        </header>

        <!-- Form Card -->
        <div class="form-card" id="formCard">
            <h1 class="form-title">Generate Your Website</h1>
            <p class="form-subtitle">3 fields. AI handles everything else.</p>

            <form id="websiteForm">
                <div class="form-group">
                    <label class="form-label">Domain Name</label>
                    <input 
                        type="text" 
                        class="form-input" 
                        id="domain" 
                        name="domain"
                        placeholder="e.g., mybusiness.com"
                        required
                    >
                    <p class="form-hint">Without https:// — just the domain</p>
                </div>

                <div class="form-group">
                    <label class="form-label">Business Type</label>
                    <select class="form-select" id="businessType" name="business_type" required>
                        <option value="">Select business type...</option>
                        <optgroup label="Services">
                            <option value="repair_shop">Repair Shop / Service Center</option>
                            <option value="cleaning">Cleaning Services</option>
                            <option value="construction">Construction / Contractor</option>
                            <option value="automotive">Automotive / Car Services</option>
                            <option value="professional">Professional Services</option>
                            <option value="legal">Legal Services</option>
                            <option value="finance">Finance / Accounting</option>
                        </optgroup>
                        <optgroup label="Retail & Commerce">
                            <option value="retail_store">Retail Store / Shop</option>
                            <option value="fashion">Fashion / Apparel</option>
                            <option value="ecommerce">E-commerce / Online Store</option>
                        </optgroup>
                        <optgroup label="Health & Wellness">
                            <option value="wellness">Health & Wellness / Spa</option>
                            <option value="beauty">Beauty / Salon</option>
                            <option value="fitness">Fitness / Gym</option>
                            <option value="medical">Medical / Healthcare</option>
                        </optgroup>
                        <optgroup label="Food & Hospitality">
                            <option value="restaurant">Restaurant / Cafe</option>
                            <option value="rental">Rental / Accommodation</option>
                            <option value="travel">Travel / Tourism</option>
                            <option value="event">Event Planning</option>
                        </optgroup>
                        <optgroup label="Creative & Education">
                            <option value="photography">Photography / Creative</option>
                            <option value="education">Education / Training</option>
                            <option value="tech">Technology / Software</option>
                        </optgroup>
                        <optgroup label="Other">
                            <option value="realestate">Real Estate / Property</option>
                            <option value="pet">Pet Services</option>
                            <option value="other">Other</option>
                        </optgroup>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label">Industry / Niche</label>
                    <input 
                        type="text" 
                        class="form-input" 
                        id="industry" 
                        name="industry"
                        placeholder="e.g., Vintage Audio Equipment Repair"
                        required
                        minlength="5"
                        maxlength="100"
                    >
                    <p class="form-hint">Be specific — helps AI generate better content</p>
                </div>

                <button type="submit" class="submit-btn" id="submitBtn">
                    <span class="btn-icon">⚡</span>
                    <span class="btn-text">Generate Website</span>
                </button>

                <div class="error-message" id="errorMessage"></div>
            </form>

            <div class="features">
                <div class="feature">
                    <span class="feature-icon">✓</span>
                    <span>AI Content</span>
                </div>
                <div class="feature">
                    <span class="feature-icon">✓</span>
                    <span>Free Images</span>
                </div>
                <div class="feature">
                    <span class="feature-icon">✓</span>
                    <span>Ads Compliant</span>
                </div>
            </div>
        </div>

        <!-- Success Card -->
        <div class="form-card success-card hidden" id="successCard">
            <div class="success-icon">✓</div>
            <h2 class="success-title">Website Ready!</h2>
            <p class="success-subtitle">Your website has been generated successfully.</p>
            <a href="#" class="download-btn" id="downloadBtn" download>
                <span>📥</span>
                Download ZIP
            </a>
            <button class="new-site-btn" onclick="resetForm()">Generate another website</button>
        </div>
    </div>

    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner"></div>
        <div class="loading-text">Generating your website...</div>
        <div class="loading-status" id="loadingStatus">Initializing...</div>
        
        <div class="progress-steps" id="progressSteps">
            <div class="progress-step" data-step="1">
                <span class="step-icon">1</span>
                <span>Generating content with AI...</span>
            </div>
            <div class="progress-step" data-step="2">
                <span class="step-icon">2</span>
                <span>Selecting design template...</span>
            </div>
            <div class="progress-step" data-step="3">
                <span class="step-icon">3</span>
                <span>Finding relevant images...</span>
            </div>
            <div class="progress-step" data-step="4">
                <span class="step-icon">4</span>
                <span>Building HTML & CSS files...</span>
            </div>
            <div class="progress-step" data-step="5">
                <span class="step-icon">5</span>
                <span>Creating ZIP package...</span>
            </div>
        </div>
    </div>

    <script src="assets/js/builder.js"></script>
</body>
</html>
